<?php
/*
* Add-on Name: CP Addons For Visual Composer
* Add-on URI: http://dev.crunchpress.com
*/
if(!class_exists("wecare_call_to_action")){
	class wecare_call_to_action{
		static $add_plugin_script;
		function __construct(){
			add_action("init",array($this,"wecare_call_to_action_init"));
			add_shortcode('wecare_call_to_action',array($this,'wecare_call_to_action_shortcode'));
		}
		function wecare_call_to_action_init(){

			if(function_exists("vc_map")){
				
				vc_map( array(
					"base" => "wecare_call_to_action",
					"name" => __( "Call To Action ", "js_composer" ),
					"class" => "wecare_call_to_action_class",
					"category" => __( 'CrunchPress', 'js_composer' ),
					"icon" => "wecare_call_to_action_icon",
					"params" => array(
					
		
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Enter Title", "js_composer" ),
								"param_name" => "element_title",
								"description" => __( "Enter Element Title Here", "js_composer" )
							),

							array(
								'type' => 'vc_link',
								'heading' => __( 'Read More (Link)', 'js_composer' ),
								'param_name' => 'readmore_url_btn',
								'description' => __( 'Add Text & Link For Button.', 'js_composer' ),
							),
							
							array(
								'type' => 'attach_image',
								"holder" => "p",
								'heading' => __( 'Background Image', 'js_composer' ),
								'param_name' => 'bg_image',
								'value' => '',
								'description' => __( 'Select Image that will appear as background.', 'js_composer' )
							),
	
							
						)
					) 
				);
			}
		}
		
		
		function wecare_call_to_action_shortcode( $atts, $content = null ) {
		
			$result = shortcode_atts( array(
				
				'element_title' => '',
				'readmore_url_btn' => '',
				'bg_image' => '',
				
	
			), $atts );
				
			
			extract( $result );

			/* Build Link First */
			
			$readmore_url_btn = vc_build_link( $readmore_url_btn );

			if(!empty($readmore_url_btn['url'])){ $readmore_url_link =  esc_url($readmore_url_btn['url']); }else{ $readmore_url_link = ''; }

			if(!empty($readmore_url_btn['title'])){ $readmore_text =  esc_attr($readmore_url_btn['title']); }else{ $readmore_text = ''; }
			
			
			/* Background Image */
				
			$bg_image = wpb_getImageBySize( array( 'attach_id' => $bg_image, 'thumb_size' => '100', 'class' => 'vc_single_image-img' ) );
			
			$bg_image =  $bg_image['p_img_large'][0];
			
			if(!empty($bg_image)){
			
				$inline_style = '<style> .call-to-action .holder { background: #000 url('.esc_url($bg_image).') no-repeat left top/cover }</style>';
			
			}else{
				
				$inline_style = '';
			}
			

			$output = $inline_style.'
			
				<section class="call-to-action">
				  <div class="container">
					<div class="holder"> <strong class="title"><span>'.$element_title.'</span></strong> 
						<a href="'.esc_url($readmore_url_link).'" class="btn-style-1">'.esc_attr($readmore_text).'</a> 
					</div>
				  </div>
				</section>';

			return $output;
			
			wp_reset_postdata();

		} /* end of function */
		
		
	}
	
	new wecare_call_to_action;
	
	if(class_exists('WPBakeryShortCode'))
	{
		class WPBakeryShortCode_wecare_call_to_action extends WPBakeryShortCode {
		}
	}
}