<?php
/*
* Add-on Name: CP Addons For Visual Composer
* Add-on URI: http://dev.crunchpress.com
*/
if(!class_exists("wecare_project_slider")){
	class wecare_project_slider{
		static $add_plugin_script;
		function __construct(){
			add_action("init",array($this,"wecare_project_slider_init"));
			add_shortcode('wecare_project_slider',array($this,'wecare_project_slider_shortcode'));
		}
		function wecare_project_slider_init(){

			if(function_exists("vc_map")){
			
				$args = array(
					'type'                     => 'projects',
					'child_of'                 => 0,
					'parent'                   => '',
					'orderby'                  => 'date',
					'order'                    => 'DESC',
					'hide_empty'               => 1,
					'hierarchical'             => 1,
					'exclude'                  => '',
					'include'                  => '',
					'number'                   => '',
					'taxonomy'                 => 'projects-categories',
					'pad_counts'               => false 
				);
				
				$categories = get_categories( $args ); 				

				$taxonomies = get_taxonomies();
				
				if($categories){
					$categoryArray[0] = "All";
					foreach($categories as $category_list){
						$categoryArray[$category_list->term_id] = $category_list->name;
					}
				} else {
					$categoryArray = array();
				}
				
	
				vc_map( array(
					"base" => "wecare_project_slider",
					"name" => __( "Projects Slider", "js_composer" ),
					"class" => "wecare_project_slider_class",
					"icon" => "wecare_project_slider",
					"category" => __( 'CrunchPress', 'js_composer' ),
					"params" => array(
					
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Element Sub Title", "js_composer" ),
								"param_name" => "element_subtitle",
								"description" => __( "Add Element Sub Title", "js_composer" )
							),

							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Element Title", "js_composer" ),
								"param_name" => "element_title",
								"description" => __( "Add Element Title", "js_composer" )
							),

							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Element Description", "js_composer" ),
								"param_name" => "element_caption",
								"description" => __( "Add Element Description Text", "js_composer" )
							),
							
						
							array(
								"type" => "dropdown",
								"holder" => "p",
								"heading" => __( "Select Category", "js_composer" ),
								"param_name" => "category_name",
								"value" => $categoryArray,
								"description" => __( "Select Category From The Dropdown", "js_composer" )
							),
							
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Project Count", "js_composer" ),
								"param_name" => "project_count",
								"description" => __( "Add Number of Projects To Display", "js_composer" )
							),
							
							array(
								'type' => 'vc_link',
								"holder" => "p",
								'heading' => __( 'View More (Link)', 'js_composer' ),
								'param_name' => 'readmore_url',
								'description' => __( 'Add Text & Link For Button.', 'js_composer' ),
							),
	
						)
					) 
				);
			}
		}
		
		
		function wecare_project_slider_shortcode( $atts, $content = null ) {
		
			$result = shortcode_atts( array(
			
				'element_subtitle' => '',
				'element_caption' => '',
				'element_title' => '',
				'category_name' => '',
				'project_count' => '6',
				'readmore_url' => '',
				

			), $atts );

			extract( $result );
			
			/* Build Link First */
			
			$readmore_url = vc_build_link( $readmore_url );

			if(!empty($readmore_url['url'])){ $readmore_url_link =  esc_url($readmore_url['url']); }else{ $readmore_url_link = ''; }

			if(!empty($readmore_url['title'])){ $readmore_text =  esc_attr($readmore_url['title']); }else{ $readmore_text = ''; }
			
			global $wpdb,$post;

			$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
			
			if($category_name != 'All' && !empty($category_name)){
				
				$term = '';
				
				$term = get_term_by('name', $category_name, 'projects-categories');
				
				if(is_object($term)){
				
					$category_id = $term->term_id;
					
					$stack_cat_all = array('tax_query' => array(
							array(
								'taxonomy' => 'projects-categories',
								'terms' => $category_id,
								'field' => 'term_id',
							)
						),
					);
					
					$args = array( 
						'post_type' 		=> 'projects',
						'posts_per_page' 	=> $project_count,
						'paged' 			=> $paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'projects-categories',
								'terms' => $category_id,
								'field' => 'term_id',
							)
						), 
						'post_status'       => 'publish',
						'orderby' 			=> 'date',
						'order' 			=> 'ASC'
					);
					
				}else{
				
					$args = array( 
						'post_type' 		=> 'projects',
						'post_status'       => 'publish',
						'paged' 			=> $paged,
						'posts_per_page' 	=> $project_count,
						'orderby'		 	=> 'date',
						'order' 			=> 'ASC'
					);
				
				}
			
			}else{
			
				
				$args = array( 
					'post_type' 		=> 'projects',
					'post_status'       => 'publish',
					'paged' 			=> $paged,
					'posts_per_page' 	=> $project_count,
					'orderby'		 	=> 'date',
					'order' 			=> 'ASC'
				);
			
			}

			query_posts($args);
			
			/* Pretty Photo Scripts */
			
			wp_enqueue_style('prettyPhoto',wecare_PATH_URL.'/frontend/css/prettyphoto.min.css');
		
			wp_enqueue_script( 'prettyPhoto', wecare_PATH_URL.'/frontend/js/jquery.prettyphoto.min.js', false, '1.0', true);
			
			/* Owl Scripts */
			wp_enqueue_script( 'cp-owl', wecare_PATH_URL.'/frontend/js/owl.carousel.min.js', false, '1.0', true);

			wp_enqueue_style('cp-owl',wecare_PATH_URL.'/frontend/css/owl.carousel.css');
			
			
			$output = '
			
			<section class="charity-works">
			  <div class="element_wrap">
				<div class="row">
				  <div class="col-md-4 col-sm-4">
					<div class="heading-style-1"> 
						<span>'.esc_attr($element_subtitle).'</span>
						<h2>'.esc_attr($element_title).'</h2>
					</div>
					<em>'.esc_attr($element_caption).'</em> 
					<a href="'.esc_url($readmore_url_link).'" class="btn-style-1">'.esc_attr($readmore_text).'</a> 
				  </div>
				  <div class="col-md-8 col-sm-8">
					<div id="charity-slider" class="owl-carousel">';
	
						if(have_posts()){ 
						
							while( have_posts() ){ the_post(); global $post;
							
								$wecare_projects_detail_xml = get_post_meta($post->ID, 'wecare_projects_detail_xml', true);
								
								$projects_duration = '';
								
								if($wecare_projects_detail_xml <> ''){
								
									$features_xml = new DOMDocument ();
									
									$features_xml->loadXML ( $wecare_projects_detail_xml );
									
									$projects_duration = wecare_find_xml_value($features_xml->documentElement,'projects_duration');
									$projects_icons = wecare_find_xml_value($features_xml->documentElement,'projects_icons');										
								}
									
				  
								$output .= '
								
									<div class="item">
										<div class="box">
										  <div class="icon-col">
											<span class="icon-box"></span> <i class="'.esc_attr($projects_icons).'" aria-hidden="true"></i> 
										  </div>
										  <h3>'.get_the_title().'</h3>
										  <p>'.mb_substr(get_the_content(),0, 58).'</p>
										</div>
									</div>';
			
		  
							} /* endwhile */ wp_reset_query();
						} /* endif */ 
						$output .= '
					</div>
				  </div>
				</div>
			  </div>
			</section>';
			
		return $output;

		wp_reset_postdata();

		} /* end of function */
		
		
	}
	
	new wecare_project_slider;
	
	if(class_exists('WPBakeryShortCode'))
	{
		class WPBakeryShortCode_wecare_project_slider extends WPBakeryShortCode {
		}
	}
}