<?php 
	/*
	 * This file is used to generate comments form.
	 */	
	if (post_password_required()){
		?> <p class="nopassword"><?php echo esc_html__('This post is password protected. Enter the password to view comments.','wecare'); ?></p> <?php
		return;
	}
	if ( have_comments() ) : ?>
		
		<h3><?php comments_number(esc_html__('No Comment','wecare'), esc_html__('One Comment','wecare'), esc_html__('% Comments','wecare') );?></h3>
		<ul id="comments" class="cp-comments">
			<?php wp_list_comments(array('callback' => 'get_comment_list')); ?>
		</ul>
		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
		<br>
		<div class="comments-navigation">
			<div class="previous"> <?php previous_comments_link(esc_html__('Older Comments','wecare')); ?> </div>
			<div class="next"> <?php next_comments_link(esc_html__('Newer Comments','wecare')); ?> </div>
		</div>
		<?php endif;  
	
	endif; 
             
	global $post;
	
	/* Form Args() */				
	$wecare_comment_form = array( 
		
		'class_form' => 'comment-form-temp',
		
		'title_reply_before' => '<div class = "heading-style-1"><h2 id="reply-title" class="comment-reply-title">',
		
		'title_reply_after' => '</h2></div>',
		
		'fields' => apply_filters( 'comment_form_default_fields', array(
		
	
			'author' => '<div class = "row"><div class="col-md-4">' .						
						'<input class="comm-field" id="author" name="author" placeholder="'.esc_html__('Name *','wecare').'" type="text" value="' .
						esc_attr( $commenter['comment_author'] ) . '" size="30" tabindex="1" />' .						
						'</div>',
						
			'email'  => '<div class="col-md-4">' .
						'<input id="email" class="comm-field" name="email" placeholder="'.esc_html__('Email *','wecare').'" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" tabindex="2" />' .						
						'</div>',

			'url'  => '<div class="col-md-4">' .
						'<input id="url" class="comm-field" name="url" placeholder="'.esc_html__('Subject *','wecare').'" type="text" value="' . esc_attr(  $commenter['comment_author_url'] ) . '" size="30" tabindex="3" />' .						
						'</div></div>' ) ),
						
			'comment_field' => '' .
						'<div class = "row"><div class="col-md-12">'.												
						'<textarea cols="60" rows="10" placeholder="'.esc_html__('Comments *','wecare').'" class="comm-area" id="comment" name="comment" aria-required="true" tabindex="4"></textarea></div></div>' .
						'',
		'title_reply' => esc_html__('Leave a Comment','wecare'),
	);
	
	comment_form($wecare_comment_form, $post->ID); 
?>