<?php
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2025 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */

class Modules_AccelerateWp_EventListener implements EventListener
{
    public function filterActions()
    {
        return ['ext_wp-toolkit_site-cloning-completed'];
    }

    public function handleEvent($objectType, $objectId, $action, $oldValues, $newValues)
    {
        if (!empty($newValues['SOURCE_INSTANCE_ID']) && !empty($newValues['TARGET_INSTANCE_ID'])) {
            $sourceId = (int)$newValues['SOURCE_INSTANCE_ID'];
            $targetId = (int)$newValues['TARGET_INSTANCE_ID'];

            pm_ApiCli::callSbin('site-cloning-completed', [
                '--source-instance-id', $sourceId,
                '--target-instance-id', $targetId,
            ]);
        }
    }
}

return new Modules_AccelerateWp_EventListener();
