<?php
/*
* Add-on Name: CP Addons For Visual Composer
* Add-on URI: http://dev.crunchpress.com
*/
if(!class_exists("wecare_events")){
	class wecare_events{
		static $add_plugin_script;
		function __construct(){
			add_action("init",array($this,"wecare_events_init"));
			add_shortcode('wecare_events',array($this,'wecare_events_shortcode'));
		}
		function wecare_events_init(){

			if(function_exists("vc_map")){
				
				 $args = array(
					'type'                     => 'event',
					'child_of'                 => 0,
					'parent'                   => '',
					'orderby'                  => 'date',
					'order'                    => 'DESC',
					'hide_empty'               => 1,
					'hierarchical'             => 1,
					'exclude'                  => '',
					'include'                  => '',
					'number'                   => '',
					'taxonomy'                 => 'event-categories',
					'pad_counts'               => false 
				);
				
				$categories = get_categories( $args ); 				
						
				
				$taxonomies = get_taxonomies();
				
				if($categories){
					$categoryArray[0] = "All";
					foreach($categories as $category_list){
						$categoryArray[$category_list->term_id] = $category_list->name;
					}
				} else {
					$categoryArray = array();
				}
				
				vc_map( array(
					"base" => "wecare_events",
					"name" => __( "Events", "js_composer" ),
					"class" => "wecare_events_class",
					"icon" => "wecare_events_icon",
					"category" => __( 'CrunchPress', 'js_composer' ),
					"params" => array(
					
						array(
								"type" => "dropdown",
								"heading" => __( "Select Style", "js_composer" ),
								"param_name" => "select_style",
								"holder" => "p",
								"value" =>  array( __( 'List View', 'js_composer' ) => 'list',
													__( 'List View 2', 'js_composer' ) => 'list2',
													__( 'Block View', 'js_composer' ) => 'block',
												),
								"description" => __( "Select Element Style", "js_composer" )
						),
						
						array(
							"type" => "textfield",
							"holder" => "p",
							"class" => "",
							"heading" => __( "Element Title", "js_composer" ),
							"param_name" => "element_title",
							"description" => __( "Enter Element Title Here", "js_composer" )
						),
						
						array(
							"type" => "textfield",
							"holder" => "p",
							"class" => "",
							"heading" => __( "Element Caption", "js_composer" ),
							"param_name" => "element_caption",
							"description" => __( "Enter Element Caption Here i.e Slider (Single)", "js_composer" )
						),
						
						array(
							"type" => "textfield",
							"holder" => "p",
							"class" => "",
							"heading" => __( "Content Length", "js_composer" ),
							"param_name" => "excerpt_length",
							"description" => __( "Enter Excerpt Length Here", "js_composer" )
						),
						
						
						array(
							"type" => "textfield",
							"holder" => "p",
							"class" => "",
							"heading" => __( "Events Count", "js_composer" ),
							"param_name" => "num_posts",
							"description" => __( "Enter Number of Events To Display", "js_composer" )
						),
						
						array(
							"type" => "dropdown",
							"holder" => "p",
							"heading" => __( "Categories", "js_composer" ),
							"param_name" => "category_name",
							"value" => $categoryArray,
							"description" => __( "Select Category From The Dropdown", "js_composer" )
						),
						
						array(
								'type' => 'vc_link',
								"holder" => "p",
								'heading' => __( 'More Events (Link)', 'js_composer' ),
								'param_name' => 'readmore_url',
								'description' => __( 'Add Link For Button.', 'js_composer' ),
						),
					)
				) );
			}
		}
		
		
		function wecare_events_shortcode( $atts, $content = null ) {
			
			$result = shortcode_atts( array(

				'select_style' => 'list',
				'element_title' => '',
				'num_posts' => '3',
				'category_name' => '',
				'excerpt_length' => '',
				'element_caption' => '',
				'readmore_url' => '',
				

			), $atts );
			
			extract( $result );
			
		
			global $wpdb,$post;

			$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
			
			if($category_name != 'All' && !empty($category_name)){
				
				$term = '';
				
				$term = get_term_by('name', $category_name, 'event-categories');
				
				if(is_object($term)){
				
					$category_id = $term->term_id;
					
					$stack_cat_all = array('tax_query' => array(
							array(
								'taxonomy' => 'event-categories',
								'terms' => $category_id,
								'field' => 'term_id',
							)
						),
					);
					
					$args = array( 
						'post_type' => 'event',
						'posts_per_page' => $num_posts,
						'paged' 			=> $paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'event-categories',
								'terms' => $category_id,
								'field' => 'term_id',
							)
						), 
						'post_status'       => 'publish',
						'orderby' 			=> 'date',
						'order' 			=> 'ASC'
					);
					
				}else{
				
					$args = array( 
						'post_type' 		=> 'event',
						'post_status'       => 'publish',
						'paged' 			=> $paged,
						'posts_per_page' 	=> $num_posts,
						'orderby'		 	=> 'date',
						'order' 			=> 'ASC'
					);
				
				}
			
			}else{
			
				
				$args = array( 
					'post_type' 		=> 'event',
					'post_status'       => 'publish',
					'paged' 			=> $paged,
					'posts_per_page' 	=> $num_posts,
					'orderby'		 	=> 'date',
					'order' 			=> 'ASC'
				);
			
			}
			
			
			query_posts($args);
			
			/* Build Link First */
			
			$readmore_url = vc_build_link( $readmore_url );

			if(!empty($readmore_url['url'])){ $readmore_url_link =  esc_url($readmore_url['url']); }else{ $readmore_url_link = ''; }

			if(!empty($readmore_url['title'])){ $readmore_text =  esc_attr($readmore_url['title']); }else{ $readmore_text = ''; }			
			
			
			if($select_style == 'list'){
			
			
				/* Slider 4 Timer CSS */
				wp_enqueue_script('cp-plugin', wecare_PATH_URL.'/frontend/js/jquery.plugin.min.js', false, '1.0', true);
				
				wp_enqueue_style('cp-countdowncs',wecare_PATH_URL.'/frontend/css/jquery.countdown.css');
				
				wp_enqueue_script('cp-countdown', wecare_PATH_URL.'/frontend/js/jquery.countdown.js', false, '1.0', true);
			
			
				$output = '
				
				 <section class="event-section">
				  <div class="element_wrap">
					<div class="heading-style-1"> 
						<span>'.esc_attr($element_caption).'</span>
						<h2>'.esc_attr($element_title).'</h2>
					</div>';
					if (class_exists('EM_Events')) {
																		 
						global $EM_Events,$bp;
										
						$counter = rand(1,1000);
						
						$order = 'ASC';
						$limit = $num_posts;
						$offset = '';
						$rowno = 0;
						$event_count = 0;
						
						$EM_Events = EM_Events::get( array('category'=>$category_name, 'group'=>'this','scope'=>'future', 'limit' => $limit, 'order' => $order) );
													
						$events_count = count ( $EM_Events );

						if($events_count > 0){
													
							foreach ( $EM_Events as $event ) {
							
								/* International Date Format */
								$localised_start_date = date_i18n(get_option('dbem_date_format'), $event->start);
								$localised_end_date = date_i18n(get_option('dbem_date_format'), $event->end);
								
								$today = date ( "Y-m-d" );
								
								if(!empty($event->location_id->name)){
									$location_summary = "<b>" . $event->get_location()->name . "</b><br/>" . $event->get_location()->address . " - " . $event->get_location()->town;
								}else{
									$location_summary = '';
								}
								
								if ($event->start_date < $today && $event->end_date < $today){
									$class .= " past";
								}
								
								/* Check Event Status */
								if ( !$event->status ){
									$class .= " pending";
								}	
								
								
								/* Event Day and Month */
								$event_month_alpha = date('M',$event->start);
								$event_day = date('d',$event->start);
								
								
								/* Get Dates In Parts */
								$event_year = date('y',$event->start);
								$event_year_4digit = date('Y',$event->start);
								$event_month = date('m',$event->start);
								$event_month_alpha = date('M',$event->start);
								$event_day = date('d',$event->start);
								
								/* Change Time Format */
								if($event->start_time <> ''){
									$event_start_time_count = date("G,i,s", strtotime($event->start_time));
								}
								
								$thumbnail_id = get_post_thumbnail_id( $event->post_id );
								$thumbnail = wp_get_attachment_image_src( $thumbnail_id , array(1140,400));
								
								$event_element_id = $counter.$event->event_id; 
							
								$content = str_replace(']]>', ']]&gt;',$event->post_content); 
								
								if(strlen($content >  $excerpt_length)){
								
										$content = mb_substr($content, 0 , $excerpt_length).'...';
										
								}else{
								
										$content = $content;
								}
								
								if(($event->start_time) <> ''){
								  
								  $event_time = date("g:i a", strtotime($event->start_time)) .'-'.  date("g:i a", strtotime($event->end_time));
								  
								
								}
								
								if(!empty($event->get_location()->name)){
								
									$event_location = $event->get_location()->name;
								
								}else{
								
									$event_location = '';
								}
								

								$formatted_event_date =  date(get_option('date_format'),strtotime($event->start_date));
										
								$output .= '
										
									<div class="event-row">
									  <div class="date-box">'.$event_day.' ' .$event_month_alpha.'<span>'.$event_year.'</span></div>
									  <div class="text-box">
										<div class="left">
										  <h3><a href="'.esc_url($event->guid).'">'.esc_attr($event->event_name).'</a></h3>
										  <div class="btn-row"> 
											<a href="'.esc_url($event->guid).'" class="admin"><i class="fa fa-user" aria-hidden="true"></i>'.get_the_author().'</a> 
											<a href="'.esc_url($event->guid).'" class="admin"><i class="fa fa-clock-o" aria-hidden="true"></i>'. $event_time .'</a>
											<a href="'.esc_url($event->guid).'" class="admin"><i class="fa fa-map-marker" aria-hidden="true"></i>'.$event_location.'</a> 
										  </div>
										  <p>'.$content.'</p>
										</div>
										<div class="btn-box"> 
											<a href="'.esc_url($event->guid).'" class="btn-style-2">'.esc_html__('Read Details','wecare').'</a> 
								 			<a href="'.esc_url($event->guid).'" class="btn-style-1">'.esc_html__('Buy Tickets','wecare').'</a> 
										</div>
									  </div>
									</div>'; 
										
									} /*end foreach */
											
								}else{

									$output .= '
									
									<div class="section-title orange-border">
					
										<h2>'.esc_attr('No Published Future Event Found','theneeds').'</h2>
									
									</div>';
									
								}
							
							} wp_reset_query(); /* endif */ 
					
						$output .= '
						<div class="btn-row"><a href="'.esc_url($readmore_url_link).'" class="btn-style-1">'.esc_attr($readmore_text).'</a></div>
					</div>
			  </section>';
			
			}
			
			if($select_style == 'list2'){
			
			
				/* Slider 4 Timer CSS */
				wp_enqueue_script('cp-plugin', wecare_PATH_URL.'/frontend/js/jquery.plugin.min.js', false, '1.0', true);
				
				wp_enqueue_style('cp-countdowncs',wecare_PATH_URL.'/frontend/css/jquery.countdown.css');
				
				wp_enqueue_script('cp-countdown', wecare_PATH_URL.'/frontend/js/jquery.countdown.js', false, '1.0', true);
			
			
				$output = '
				
				<section class="event-section event-list">
				  <div class="element_wrap">';
					
					if (class_exists('EM_Events')) {
																		 
						global $EM_Events,$bp;
										
						$counter = rand(1,1000);
						
						$order = 'ASC';
						$limit = $num_posts;
						$offset = '';
						$rowno = 0;
						$event_count = 0;
						
						$EM_Events = EM_Events::get( array('category'=>$category_name, 'group'=>'this','scope'=>'future', 'limit' => $limit, 'order' => $order) );
													
						$events_count = count ( $EM_Events );

						if($events_count > 0){
													
							foreach ( $EM_Events as $event ) {
							
								/* International Date Format */
								$localised_start_date = date_i18n(get_option('dbem_date_format'), $event->start);
								$localised_end_date = date_i18n(get_option('dbem_date_format'), $event->end);
								
								$today = date ( "Y-m-d" );
								
								if(!empty($event->location_id->name)){
									$location_summary = "<b>" . $event->get_location()->name . "</b><br/>" . $event->get_location()->address . " - " . $event->get_location()->town;
								}else{
									$location_summary = '';
								}
								
								if ($event->start_date < $today && $event->end_date < $today){
									$class .= " past";
								}
								
								/* Check Event Status */
								if ( !$event->status ){
									$class .= " pending";
								}	
								
								
								/* Event Day and Month */
								$event_month_alpha = date('M',$event->start);
								$event_day = date('d',$event->start);
								
								
								/* Get Dates In Parts */
								$event_year = date('y',$event->start);
								$event_year_4digit = date('Y',$event->start);
								$event_month = date('m',$event->start);
								$event_month_alpha = date('M',$event->start);
								$event_day = date('d',$event->start);
								
								/* Change Time Format */
								if($event->start_time <> ''){
									$event_start_time_count = date("G,i,s", strtotime($event->start_time));
								}
								
								$thumbnail_id = get_post_thumbnail_id( $event->post_id );
								$thumbnail = wp_get_attachment_image_src( $thumbnail_id , array(1140,400));
								
								$event_element_id = $counter.$event->event_id; 
							
								$content = str_replace(']]>', ']]&gt;',$event->post_content); 
								
								if(strlen($content >  $excerpt_length)){
								
										$content = mb_substr($content, 0 , $excerpt_length).'...';
										
								}else{
								
										$content = $content;
								}
								
								if(($event->start_time) <> ''){
								  
								  $event_time = date("g:i a", strtotime($event->start_time)) .'-'.  date("g:i a", strtotime($event->end_time));
								  
								
								}
								
								if(!empty($event->get_location()->name)){
								
									$event_location = $event->get_location()->name;
								
								}else{
								
									$event_location = '';
								}
								

								$formatted_event_date =  date(get_option('date_format'),strtotime($event->start_date));
										
								$output .= '
								
								<div class="event-row">
								  <div class="date-box">'.$event_day.' ' .$event_month_alpha.'<span>'.$event_year_4digit.'</span></div>
								  <div class="text-box">
									<div class="btn-box"> 
										<a href="'.esc_url($event->guid).'" class="btn-style-2">'.esc_html__('Read Details','wecare').'</a> 
								 	    <a href="'.esc_url($event->guid).'" class="btn-style-1">'.esc_html__('Buy Tickets','wecare').'</a> 
									</div>
									<div class="left">
									  <h3><a href="'.esc_url($event->guid).'">'.esc_attr($event->event_name).'</a></h3>
										<div class="btn-row"> 
											<a href="'.esc_url($event->guid).'" class="admin"><i class="fa fa-user" aria-hidden="true"></i>'.get_the_author().'</a> 
											<a href="'.esc_url($event->guid).'" class="admin"><i class="fa fa-clock-o" aria-hidden="true"></i>'. $event_time .'</a>
											<a href="'.esc_url($event->guid).'" class="admin"><i class="fa fa-map-marker" aria-hidden="true"></i>'.$event_location.'</a> 
										</div>
									  <p>'.$content.'</p>
									</div>
								  </div>
								</div>';
			
							} /*end foreach */
											
						}else{

							$output .= '
							
							<div class="section-title orange-border">
			
								<h2>'.esc_attr('No Published Future Event Found','theneeds').'</h2>
							
							</div>';
							
						}
							
					} wp_reset_query(); /* endif */ 
					
						$output .= '
						
					</div>
			  </section>';
			
			}
			
			if($select_style == 'block'){

				$output = '
				
				<section class="event-section event-list-2">
					<div class="element_wrap">';
						if (class_exists('EM_Events')) {
																	 
							global $EM_Events,$bp;
											
							$counter = rand(1,1000);
							
							$order = 'ASC';
							$limit = $num_posts;
							$offset = '';
							$rowno = 0;
							$event_count = 0;
					
							$EM_Events = EM_Events::get( array('category'=>$category_name, 'group'=>'this','scope'=>'future', 'limit' => $limit, 'order' => $order) );
														
							$events_count = count ( $EM_Events );

							if($events_count > 0){
														
								foreach ( $EM_Events as $event ) {
								
									/* International Date Format */
									$localised_start_date = date_i18n(get_option('dbem_date_format'), $event->start);
									$localised_end_date = date_i18n(get_option('dbem_date_format'), $event->end);
									
									$today = date ( "Y-m-d" );
									
									if(!empty($event->location_id->name)){
										$location_summary = "<b>" . $event->get_location()->name . "</b><br/>" . $event->get_location()->address . " - " . $event->get_location()->town;
									}else{
										$location_summary = '';
									}
									
									if ($event->start_date < $today && $event->end_date < $today){
										$class .= " past";
									}
									
									/* Check Event Status */
									if ( !$event->status ){
										$class .= " pending";
									}	
									
									
									/* Event Day and Month */
									$event_month_alpha = date('M',$event->start);
									$event_day = date('d',$event->start);
									
									
									/* Get Dates In Parts */
									$event_year = date('y',$event->start);
									$event_year_4digit = date('Y',$event->start);
									$event_month = date('m',$event->start);
									$event_month_alpha = date('M',$event->start);
									$event_day = date('d',$event->start);
									
									/* Change Time Format */
									if($event->start_time <> ''){
										$event_start_time_count = date("G,i,s", strtotime($event->start_time));
									}
									
									$thumbnail_id = get_post_thumbnail_id( $event->post_id );
									$thumbnail = wp_get_attachment_image_src( $thumbnail_id , array(1140,400));
									
									$event_element_id = $counter.$event->event_id; 
								
									$content = str_replace(']]>', ']]&gt;',$event->post_content); 
									
									if(strlen($content >  $excerpt_length)){
									
											$content = mb_substr($content, 0 , $excerpt_length).'...';
											
									}else{
									
											$content = $content;
									}
									
									if(($event->start_time) <> ''){
									  
									  $event_time = date("g:i a", strtotime($event->start_time)) .'-'.  date("g:i a", strtotime($event->end_time));
									  
									
									}
									
									if(!empty($event->get_location()->name)){
									
										$event_location = $event->get_location()->name;
									
									}else{
									
										$event_location = '';
									}
									

									$formatted_event_date =  date(get_option('date_format'),strtotime($event->start_date));
									
									$output .= '
									
									<div class="event-list-style-2-row">
										<div class="text-col">
											<div class="date-box">'.$event_day.' ' .$event_month_alpha.'<b>'.$event_year_4digit.'</b></div>
											<h3><a href="'.esc_url($event->guid).'">'.esc_attr(mb_substr($event->event_name,0, 29)).'</a></h3>
											<div class="btn-row"> 
												<span><i class="fa fa-user" aria-hidden="true"></i>'.get_the_author().'</span> 
												<span><i class="fa fa-clock-o" aria-hidden="true"></i>'. $event_time .'</span> 
											</div>
											<p>'.$content.'</p>
											<a href="'.esc_url($event->guid).'" class="btn-style-2">'.esc_html__('Read Details','wecare').'</a>
							   			<a href="'.esc_url($event->guid).'" class="btn-style-1">'.esc_html__('Buy Tickets','wecare').'</a> 
										</div>
										<div class="thumb"><a href="'.esc_url($event->guid).'">'.get_the_post_thumbnail($event->post_id, array(360,300)).'</a></div>
									</div>';

									
								} /*end foreach */
										
							}else{

								$output .= '
								
								<div class="section-title orange-border">
				
									<h2>'.esc_attr('No Published Future Event Found','wecare').'</h2>
								
								</div>';
								
							}
						
						} wp_reset_query(); /* endif */ 
				
						$output .= '
					</div>
				</section>';
			
			}

			return $output;

			wp_reset_postdata();
				

		} /* OutPut Function Ends Here */
		
		
	} /* class ends here */
	
	new wecare_events;
	
	if(class_exists('WPBakeryShortCode'))
	{
		class WPBakeryShortCode_wecare_events extends WPBakeryShortCode {
		}
	}
}