<?php
/*
* Add-on Name: CP Addons For Visual Composer
* Add-on URI:  http://dev.crunchpress.com
*/
if(!class_exists("wecare_volunteer_profile")){
	class wecare_volunteer_profile{
		static $add_plugin_script;
		function __construct(){
			add_action("init",array($this,"wecare_volunteer_profile_init"));
			add_shortcode('wecare_volunteer_profile',array($this,'wecare_volunteer_profile_shortcode'));
		}
		function wecare_volunteer_profile_init(){

			if(function_exists("vc_map")){
				
				 $args = array(
					'type'                     => 'team',
					'child_of'                 => 0,
					'parent'                   => '',
					'orderby'                  => 'name',
					'order'                    => 'ASC',
					'hide_empty'               => 1,
					'hierarchical'             => 1,
					'exclude'                  => '',
					'include'                  => '',
					'number'                   => '',
					'taxonomy'                 => 'team-category',
					'pad_counts'               => false 
				);
				
				$categories = get_categories( $args ); 	

				$taxonomies = get_taxonomies();
				
				if($categories){
					$categoryArray[0] = "All";
					foreach($categories as $category_list){
						$categoryArray[$category_list->term_id] = $category_list->name;
					}
				} else {
					$categoryArray = array();
				}
				
				vc_map( array(
					"base" => "wecare_volunteer_profile",
					"name" => __( "Volunteer", "js_composer" ),
					"class" => "wecare_volunteer_profile_class",
					"category" => __( 'CrunchPress', 'js_composer' ),
					"icon" => "wecare_volunteer_profile_icon",
					"params" => array(
					
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Element Title", "js_composer" ),
								"param_name" => "element_title",
								"description" => __( "Enter Element Title Here", "js_composer" )
							),
							

							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Element Caption", "js_composer" ),
								"param_name" => "element_caption",
								"description" => __( "Enter Element Caption i.e Grid", "js_composer" )
							),

							
							array(
								"type" => "dropdown",
								"holder" => "p",
								"heading" => __( "Categories", "js_composer" ),
								"param_name" => "category_name_about",
								"value" => $categoryArray,
								"description" => __( "Select Category To Fetch Tour Guides From", "js_composer" )
							),

					)
				) );
			}
		}
		
		
		function wecare_volunteer_profile_shortcode( $atts, $content = null ) {
			

			$result = shortcode_atts( array(

				'element_title' => '',
				'category_name_about' => '',
				'element_caption' => '',
				
			), $atts );
			
			extract( $result );
			
			global $wpdb,$post;
			
			$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

			if($category_name_about != 'All' && !empty($category_name_about)){
				
				$term = '';
				
				$term = get_term_by('name', $category_name_about, 'team-category');
				
				if(is_object($term)){
				
					$category_id = $term->term_id;
					
					$args = array( 
						'post_type' 		=> 'team',
						'posts_per_page' 	=> 1,
						'paged' 			=> $paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'team-category',
								'terms' => $category_id,
								'field' => 'term_id',
							)
						), 
						'post_status'       => 'publish',
						'orderby' 			=> 'date',
						'order' 			=> 'ASC'
					);
				
				}else{
				
					$args = array( 
						'post_type' 		=> 'team',
						'paged' 			=> $paged,
						'posts_per_page' 	=> 1,
						'post_status'       => 'publish',
						'orderby' 			=> 'date',
						'order' 			=> 'ASC'
					);
				
				}

			}else{
				
				$args = array( 
					'post_type' 		=> 'team',
					'paged' 			=> $paged,
					'posts_per_page' 	=> 1,
					'post_status'       => 'publish',
					'orderby' 			=> 'date',
					'order' 			=> 'ASC'
				);
				
			}

			query_posts($args);	
			

			$output = '
			
			<section class="donation-row">
			  <div class="element_wrap">
				<div class="row">';
				  
					if ( have_posts() ) {
							
						while ( have_posts() ) { the_post(); global $post;

							if(!empty($num_characters)){
								
								if (strlen(get_the_content()) > $num_characters){
									
									$team_content =  mb_substr(strip_shortcodes(get_the_content()), 0, $num_characters);
								
								}else{
									
									$team_content = htmlspecialchars_decode(strip_shortcodes(get_the_content()));
								}
							}else{
									$team_content = htmlspecialchars_decode(strip_shortcodes(get_the_content()));
							}
							
							/* Single Team Information */
								
								$team_detail_xml = get_post_meta($post->ID, 'team_detail_xml', true);
								
								if($team_detail_xml <> ''){
								
									$team_xml = new DOMDocument ();
									
									$team_xml->loadXML ( $team_detail_xml );
									$team_designation = wecare_find_xml_value($team_xml->documentElement,'team_designation');
									$team_facebook = wecare_find_xml_value($team_xml->documentElement,'team_facebook');
									$team_linkedin = wecare_find_xml_value($team_xml->documentElement,'team_linkedin');
									$team_twitter = wecare_find_xml_value($team_xml->documentElement,'team_twitter');
									$google_plus = wecare_find_xml_value($team_xml->documentElement,'google_plus');
									$wecare_pinterest = wecare_find_xml_value($team_xml->documentElement,'wecare_pinterest');
									$wecare_youtube = wecare_find_xml_value($team_xml->documentElement,'wecare_youtube');
									$wecare_instagram = wecare_find_xml_value($team_xml->documentElement,'wecare_instagram');
									
								}
								
								/* Facebook URl */
								if(isset($team_facebook) AND $team_facebook <> ''){
									$facebook_li = '<li><a href="'.esc_url($team_facebook).'"><i class="fa fa-facebook" aria-hidden="true"></i></a></li>';
								}else{
									$facebook_li ='';
								}
								
								/* Twitter URl */
								if(isset($team_twitter) AND $team_twitter <> ''){
									$twitter_li = '<li><a href="'.esc_url($team_twitter).'"><i class="fa fa-twitter" aria-hidden="true"></i></a></li>';
								}else{
									$twitter_li = '';
								}
								
								/* LinkedIn URl */
								if(isset($team_linkedin) AND $team_linkedin <> ''){
									$linkedin_li = '<li><a href="'.esc_url($team_linkedin).'"><i class="fa fa-linkedin" aria-hidden="true"></i></a></li>';
								}else{
									$linkedin_li = '';
								}
								
								/* google_plus URl */
								if(isset($google_plus) AND $google_plus <> ''){
									$google_plus = '<li><a href="'.esc_url($google_plus).'"><i class="fa fa-google-plus" aria-hidden="true"></i></a></li>';
								}else{
									$google_plus = '';
								}
								
								/* Pinterest URl */
								if(isset($wecare_pinterest) AND $wecare_pinterest <> ''){
									$pinterest_li = '<li><a href="'.esc_url($wecare_pinterest).'"><i class="fa fa-pinterest-p" aria-hidden="true"></i></a></li>';
								}else{
									$pinterest_li ='';
								}
								
								/* Facebook URl */
								if(isset($wecare_youtube) AND $wecare_youtube <> ''){
									$youtube_li = '<li><a href="'.esc_url($wecare_youtube).'"><i class="fa fa-youtube" aria-hidden="true"></i></a></li>';
								}else{
									$youtube_li ='';
								}
				
								$output .= '
								
								<div class="col-md-12">
									<div class="team-style-1">
									  <div class="heading-style-1"> 
										<span>'.$element_caption.'</span>
										<h2>'.$element_title.'</h2>
									  </div>
									  <div class="team-box-1">
										<div class="frame">'.get_the_post_thumbnail($post->ID, array(282,282)).'</div>
										<div class="outer">
										  <div class="text-box">
											<h3><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
											<span>'.$team_designation.'</span>
											<ul class="team-social-1">
											  '.$google_plus.$twitter_li.$linkedin_li.$facebook_li.$pinterest_li.$youtube_li.'
											</ul>
										  </div>
										</div>
									  </div>
									</div>
								  </div>';
													
			
						} /* endwhile */  wp_reset_query();

					}
					
					$output .= '
				  </div>
			   </div>
			</section>';

			return $output;

			wp_reset_postdata();
		} /* end of function */
	} /* end of class */
	
	new wecare_volunteer_profile;
	
	if(class_exists('WPBakeryShortCode'))
	{
		class WPBakeryShortCode_wecare_volunteer_profile extends WPBakeryShortCode {
		}
	}
}